/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities;

import com.finallion.graveyard.init.TGTileEntities;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GravestoneBlockEntity
extends TileEntity {
    private final ITextComponent[] messages = new ITextComponent[]{StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_};
    private boolean isEditable = true;
    private PlayerEntity editor;
    private final IReorderingProcessor[] renderMessages = new IReorderingProcessor[4];
    private DyeColor color = DyeColor.BLACK;

    public GravestoneBlockEntity() {
        super((TileEntityType)TGTileEntities.GRAVESTONE_BLOCK_ENTITY.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.messages[i]);
            p_189515_1_.func_74778_a("Text" + (i + 1), s);
        }
        p_189515_1_.func_74778_a("Color", this.color.func_176762_d());
        return p_189515_1_;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        this.isEditable = false;
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.color = DyeColor.func_204271_a((String)p_230337_2_.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        for (int i = 0; i < 4; ++i) {
            String s = p_230337_2_.func_74779_i("Text" + (i + 1));
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
            if (this.field_145850_b instanceof ServerWorld) {
                try {
                    this.messages[i] = TextComponentUtils.func_240645_a_((CommandSource)this.createCommandSourceStack(null), (ITextComponent)itextcomponent, (Entity)null, (int)0);
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    this.messages[i] = itextcomponent;
                }
            } else {
                this.messages[i] = itextcomponent;
            }
            this.renderMessages[i] = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getMessage(int p_212366_1_) {
        return this.messages[p_212366_1_];
    }

    public void setMessage(int p_212365_1_, ITextComponent p_212365_2_) {
        this.messages[p_212365_1_] = p_212365_2_;
        this.renderMessages[p_212365_1_] = null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor getRenderMessage(int p_242686_1_, Function<ITextComponent, IReorderingProcessor> p_242686_2_) {
        if (this.renderMessages[p_242686_1_] == null && this.messages[p_242686_1_] != null) {
            this.renderMessages[p_242686_1_] = p_242686_2_.apply(this.messages[p_242686_1_]);
        }
        return this.renderMessages[p_242686_1_];
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEditable(boolean p_145913_1_) {
        this.isEditable = p_145913_1_;
        if (!p_145913_1_) {
            this.editor = null;
        }
    }

    public void setAllowedPlayerEditor(PlayerEntity p_145912_1_) {
        this.editor = p_145912_1_;
    }

    public PlayerEntity getPlayerWhoMayEdit() {
        return this.editor;
    }

    public boolean executeClickCommands(PlayerEntity p_174882_1_) {
        for (ITextComponent itextcomponent : this.messages) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            p_174882_1_.func_184102_h().func_195571_aL().func_197059_a(this.createCommandSourceStack((ServerPlayerEntity)p_174882_1_), clickevent.func_150668_b());
        }
        return true;
    }

    public CommandSource createCommandSourceStack(@Nullable ServerPlayerEntity p_195539_1_) {
        String s = p_195539_1_ == null ? "Sign" : p_195539_1_.func_200200_C_().getString();
        StringTextComponent itextcomponent = p_195539_1_ == null ? new StringTextComponent("Sign") : p_195539_1_.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)p_195539_1_);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean setColor(DyeColor p_214068_1_) {
        if (p_214068_1_ != this.getColor()) {
            this.color = p_214068_1_;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }
}

